/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common;

import com.unascribed.ears.common.WritableEarsImage;
import java.nio.IntBuffer;

public class RawEarsImage
implements WritableEarsImage {
    private final int width;
    private final int height;
    private final IntBuffer data;
    private final boolean swapRedBlue;

    public RawEarsImage(int[] data, int width, int height, boolean swapRedBlue) {
        this(IntBuffer.wrap(data), width, height, swapRedBlue);
    }

    public RawEarsImage(IntBuffer data, int width, int height, boolean swapRedBlue) {
        this.data = data;
        this.width = width;
        this.height = height;
        this.swapRedBlue = swapRedBlue;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getARGB(int x, int y) {
        int raw = this.data.get(y * this.width + x);
        if (this.swapRedBlue) {
            int swapped = raw & 0xFF00FF00;
            swapped |= (raw & 0xFF0000) >> 16;
            return swapped |= (raw & 0xFF) << 16;
        }
        return raw;
    }

    public String toString() {
        return "RawEarsImage[" + this.getWidth() + "x" + this.getHeight() + ", swapRedBlue=" + this.swapRedBlue + ", data=[" + this.data.limit() + " entries]]";
    }

    @Override
    public void setARGB(int x, int y, int argb) {
        if (this.swapRedBlue) {
            int swapped = argb & 0xFF00FF00;
            swapped |= (argb & 0xFF0000) >> 16;
            swapped |= (argb & 0xFF) << 16;
            argb = swapped;
        }
        this.data.put(y * this.width + x, argb);
    }

    @Override
    public WritableEarsImage copy() {
        int[] copy = new int[this.width * this.height];
        this.data.position(0);
        this.data.get(copy);
        this.data.position(0);
        return new RawEarsImage(copy, this.width, this.height, this.swapRedBlue);
    }
}

